#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Infinite Cube ZoomMod02.fsh   by  bitless 
//https://www.shadertoy.com/view/3lc3zH
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Author: bitless
// Title: Infinite Cube Zoom
// Thanks to Patricio Gonzalez Vivo & Jen Lowe for "The Book of Shaders"
// and Fabrice Neyret (FabriceNeyret2) for https://shadertoyunofficial.wordpress.com/
// and Inigo Quilez (iq) for  https://iquilezles.org/www/index.htm
// and whole Shadertoy community for inspiration.

#define PI 3.1415926
#define hash1( n ) fract(sin(n)*43758.5453)
#define hue(v) ( .6 + .6 * cos( 6.3*(v) + vec4(0,23,21,0) ) )

float grad(float a) {
    float  sm = .005;
    float f = 1./3.;
    a = mod(a+1.,2.);
    return mix(
                    mix(.45 //SIDE1
                       ,.65 //SIDE2
                       , smoothstep (sm,-sm,abs(1.+f-a)-f)) 
                    ,.95 // BOTTOM-TOP
                    , smoothstep (f+sm, f-sm, 1.-abs(1.-a))); 
}

//void mainImage( out vec4 fragColor, in vec2 g)
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 g ) 
vec4 mainImage( out vec4 fragColor, in vec2 g )
{
    vec2 r = iResolution.xy
        ,st = (g+g-r)/r.y;
    st += st * length(st)*.1;

    float a = atan(st.x,st.y)/PI
		,T = iTime;

    float g1  = grad(a)
        ,g2 = grad(a+1.);

    float l = dot(abs(st),normalize(vec2(1.,1.73)));
    l = log2(max(l,abs(st.x)))-T;
    float fl = fract(l);
    
    float sm = fwidth(l)*1.5;

    vec4 c = hue(a+T*.1)
        ,c2 = mix(hue(hash1(floor(l)-1.)),c,.3)
        ,c3 = mix(hue(hash1(floor(l)+1.)),c,.3);
    c = mix(hue(hash1(floor(l))),c,.3);

    if (mod(l,2.)<1.) {
        c *= g1;
        c2 *= g2;
        c = mix(
                mix(c2,c,smoothstep(-sm,sm,fl-.005))
                ,c2*.75
                ,smoothstep (.4, 0., fl)*0.25)
           * (1.-smoothstep(.1,0.,abs(mod(a+1.,2./3.)-1./3.))*.25);}
    else {
        c *= g2;
        c2 *= g1;
        c3 *= g1;
        c = mix(
                mix(c2,c,smoothstep(-sm,sm,fl-.005))
                ,c3*.5
                ,smoothstep (.7, 1., fl)*.2);}

    fragColor = c;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

